<?php if(!defined('BASEPATH')) exit('No direct script access allowed'); ?>

<?php $title = (!empty($judul_kategori))? $judul_kategori : "Artikel Terkini" ?>
<?php if (is_array($title)): ?>
	<?php foreach ($title as $item): ?>
		<?php $title= "Kategori : ".$item ?>
	<?php endforeach; ?>
<?php endif; ?>
<div class="container main-container text-center mt-0 mb-2" id="artikel">
    <div class="card fullscreen pink-gradient">
        <h5 class="mt-2 mb-2"><b><?= $title ?></b></h5>
    </div>
</div>
<?php if ($artikel): ?>
    <div class="container main-container mt-0">
        <div class="row">
            <?php foreach ($artikel as $data): ?>
                <?php $abstrak = potong_teks($data['isi'], 300) ?>
                <div class="col-12 col-md-6">
                    <div class="card mb-2">
						<a href="<?= site_url('artikel/'.buat_slug($data))?>" title="Baca Selengkapnya">
                        <div class="blog-header-img" style="max-height:250px">
                            <?php if($data['gambar']!='' and is_file(LOKASI_FOTO_ARTIKEL."sedang_".$data['gambar'])): ?>
                            <img src="<?= AmbilFotoArtikel($data['gambar'],'sedang') ?>" class="img-responsive cover img-fluid opacity-100">
                            <?php else: ?>
                            <img src="<?= base_url("$this->theme_folder/$this->theme/assets/img/noimage.png") ?>" class="img-responsive cover img-fluid opacity-100">
                            <?php endif; ?>
                        </div>
						</a>
                        <div class="card-header border-bottom">
                            <div class="media">
                                <div class="icon-circle icon-40 bg-light-primary mr-3">
                                    <i class="material-icons">fingerprint</i>
                                </div>
                                <div class="media-body">
                                    <h6 class="my-0 content-color-primary"><a href="<?= site_url('artikel/'.buat_slug($data))?>" title="Baca Selengkapnya"><?= $data["judul"] ?></a></h6>
                                    <p class="small mb-0">
                                        <i class="material-icons icon-sm">date_range</i> <?= tjs($data['tgl_upload'],'s');?>
                                        <i class="material-icons icon-sm">person</i> <?= $data['owner'] ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="card-body text-hide-xs" style="min-height:150px">
                            <div class="mb-0">
                                <p align="justify"><?= $abstrak ?> ...</p>
                            </div>
                        </div>
                        <div class="card-footer border-top">
                            <div class="row">
                                <div class="col">
                                    <div class="media">
                                        <div class="media-body">
                                            <p class="content-color-secondary mb-0 small">
                                                <i class="material-icons icon-sm">chat</i> <?= number_format($this->db->query("SELECT * FROM komentar WHERE id_artikel = '".$data['id']."' AND status ='1'")->num_rows(),0,',','.') ?> Komentar
                                                <?php if (trim($data['kategori']) != '') : ?>
                                                <i class="material-icons icon-sm">flag</i> <?= $data['kategori']?>
                                                <?php endif; ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="text-right pr-3">
                                    <div class="media">
                                        <div class="media-body">
                                            <p class="content-color-secondary mb-0 small">
                                                <i class="material-icons icon-sm">favorite</i> <?= hit($data['hit']) ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php else: ?>
    <?php $this->load->view($folder_themes .'/commons/404') ?>
<?php endif; ?>
