tinymce.PluginManager.add('penerima_bantuan', function( editor, url ) {

	editor.ui.registry.addMenuButton('penerima_bantuan', {
      text: 'Penerima Bantuan',
      fetch: function(callback) {
				var items = [];

				var menuItem = {
					type: 'nestedmenuitem',
					icon: 'user',
					text: 'Penerima Bantuan (Penduduk)',
					getSubmenuItems: function() {
						return [
							{
								type: 'menuitem',
								text: 'Grafik Penerima Bantuan (Penduduk)',
								icon: 'align-left',
								onAction: function() {
									editor.insertContent('[[penerima_bantuan_penduduk_grafik]]');
								}
							},
							{
								type: 'menuitem',
								text: 'Daftar Penerima Bantuan (Penduduk)',
								icon: 'table',
								onAction: function() {
									editor.insertContent('[[penerima_bantuan_penduduk_daftar]]');
								}
							}
					];
					}
				};
				items.push(menuItem);

				var menuItem = {
					type: 'nestedmenuitem',
					icon: 'home',
					text: 'Penerima Bantuan (Keluarga)',
					getSubmenuItems: function() {
						return [
							{
								type: 'menuitem',
								text: 'Grafik Penerima Bantuan (Keluarga)',
								icon: 'align-left',
								onAction: function() {
									editor.insertContent('[[penerima_bantuan_keluarga_grafik]]');
								}
							},
							{
								type: 'menuitem',
								text: 'Daftar Penerima Bantuan (Keluarga)',
								icon: 'table',
								onAction: function() {
									editor.insertContent('[[penerima_bantuan_keluarga_daftar]]');
								}
							}
					];
					}
				};
				items.push(menuItem);

        callback(items);
      },
    });

});
